library(GEOquery)

my.gse = "GSE5406" 
ds <- GEOquery::getGEO(my.gse)
samp.info <- Biobase::pData(ds[[1]])
exprs <- Biobase::exprs(ds[[1]])

#------------------------------------------------------------------------------------------------------------------------------------
#Annotation -- with library
#for GSE5406
library(hgu133plus2.db)
library(annotate)
ID <- row.names(exprs)
Symbol<-getSYMBOL(ID,"hgu133plus2.db")
sym <- as.data.frame(Symbol)
data <- as.data.frame(exprs) 
data <- cbind(sym,data)  #sütun ekleme

i <- which(is.na(data$Symbol) == TRUE)
data<-data[-c(i),]
X <- data.table::as.data.table(data)  #library(data.table), data.table, data.frame'e gore daha fazla islem yapabilmeye olanak saglar.
final_data <- X[,lapply(.SD,mean),"Symbol"] #Symbol sütununda tekrar eden genler var, bu satırların ortalaması alınıp tek bir satır olarak yazılacak.
final_data <- as.data.frame(final_data)
rownames(final_data) <- final_data[,1] 
final_data <- final_data[,-c(1)]
final_data  = t(final_data) 
final_data <- as.data.frame(final_data)

#Metadata dan case-control bilgilerini gen ifadesi verisetine ekleme
table (rownames(final_data) == rownames(samp.info)) #exprs ve metadata datasetlerindeki samplelarin ayni sirada oldugunu kontrol ettik.
final_data$label = "case"
final_data$label[grepl("nonfailing", samp.info$title)] <- "control"
write.csv(final_data,file=paste0("geo_downloads/",my.gse,"/",my.gse,"withLabel.csv"))


#------------------------------------------------------------------------------------------------------------------------------------
#Annotation -- with annotation file --- BU KISIM DERSTE ANLATILMADI, BAŞKA BİR DERSTE VEYA BİR VIDEO KAYDINDA ANLATILACAK.
#for GSE67492
gpl_file = "GPL6244-17930.xlsx"  
annotation_file = openxlsx::read.xlsx(paste0("geo_downloads/",gpl_file), colNames = FALSE)
Symbol = subset(annotation_file,select=c(X1, X11))
sym <- as.data.frame(Symbol)

data <- as.data.frame(exprs) 
data$X1 = rownames(data)
df2 <- merge(x=data,y=sym, by="X1")
i <- which(is.na(df2$X11) == TRUE) #gen ataması olmayan indisler
df2<-df2[-c(i),] #bu indisleri remove et.
df2 = df2[,-c(1)] #ilk sutunu remove et.

X <- data.table::as.data.table(df2)  #library(data.table), data.table, data.frame'e gore daha fazla islem yapabilmeye olanak saglar.
final_data <- X[,lapply(.SD,mean),"X11"] #gen sütununda tekrar eden genler var, bu satırların ortalaması alınıp tek bir satır olarak yazılacak.
final_data <- as.data.frame(final_data)
rownames(final_data) <- final_data[,1] 
final_data <- final_data[,-c(1)]
final_data  = t(final_data) 
final_data = as.data.frame(final_data)

#Metadata dan case-control bilgilerini gen ifadesi verisetine ekleme
final_data$label = "case"
table(rownames(samp.info) == rownames(final_data)) #TRUE çıktı.
final_data$label[grepl("Control", samp.info$title)] <- "control"
final_data$label
write.csv(final_data,file=paste0("geo_downloads/",my.gse,"/",my.gse,"withLabel.csv"))
#------------------------------------------------------------------------------------------------------------------------------------




