#include <unistd.h>     // For read, write, close, STDOUT_FILENO, etc.
#include <stdio.h>      // For standard I/O functions like printf, fgets
#include <stdlib.h>     // For standard library functions like exit
#include <string.h>     // For string handling functions like strlen
#include <sys/types.h>  // For data types like size_t
#include <sys/wait.h>   // For waitpid, if used in extensions
#include <sys/stat.h>   // For file status, permissions, etc.
#include <fcntl.h>      // For file control options like open, O_WRONLY, O_RDONLY
#include <errno.h>      // For error handling

#define MAX_LINE 80     // Maximum length of the buffer for reading and writing
#define FIFO1 "/tmp/fifo.1"  // Define the path for the first named pipe (FIFO)
#define FIFO2 "/tmp/fifo.2"  // Define the path for the second named pipe (FIFO)

// Function prototype for client
void client(int readfd, int writefd);

int main(int argc, char *argv[]) {
    int readfd, writefd;

    // Open the first FIFO (FIFO1) for writing and the second FIFO (FIFO2) for reading
    writefd = open(FIFO1, O_WRONLY);
    readfd = open(FIFO2, O_RDONLY);

    /*
        FIFO1 = client->server
        FIFO2 = server->client
    */
    

    // Call client function with the read and write file descriptors
    client(readfd, writefd);

    // Close both FIFOs after communication is complete
    close(readfd);
    close(writefd);

    // To show temporary FIFO files
    char ch;
    scanf(" %c", &ch);

    // Unlink (remove) the FIFOs after usage
    unlink(FIFO1);
    unlink(FIFO2);

    exit(0);
}

// Client function, which sends a filename to the server and receives file content
void client(int readfd, int writefd) {
    size_t len;
    size_t n;
    char buff[MAX_LINE];

    printf("Enter a file name\n");
    fgets(buff, MAX_LINE, stdin);   // Read user input (filename) from standard input
    len = strlen(buff);             // Get the length of the input
    if (buff[len - 1] == '\n')      // If there's a newline at the end of input
        len--;                      // Adjust length to remove the newline

    // Write the filename to the server via the FIFO (write end)
    write(writefd, buff, len);
    printf("\nSending file name '%s' to server\n\n", buff);

    // Read the server's response (file contents or error) and output to standard output
    while ((n = read(readfd, buff, MAX_LINE)) > 0)
        write(STDOUT_FILENO, buff, n);  // Write server's response to standard output
}
