#include <stdio.h>
#include <mqueue.h>         // For POSIX message queue functions
#include <stdlib.h>
#include <unistd.h>
#include <time.h>           // For working with timestamps
#include <string.h>

#define MSGQOBJ_NAME    "/test2"    // Name of the message queue object
#define MAX_MSG_LEN     10000       // Maximum message length

int main(int argc, char *argv[]) {
    mqd_t msgq_id;                  // Message queue descriptor
    char msgcontent[MAX_MSG_LEN];   // Buffer for the message content
    int msgsz;                      // Size of the received message
    unsigned int sender;            // Priority/sender information
    struct mq_attr msgq_attr;       // Structure to store message queue attributes
    
    /* Open the existing message queue with read-write permissions */
    msgq_id = mq_open(MSGQOBJ_NAME, O_RDWR);
    
    if (msgq_id == (mqd_t)-1) {     // If mq_open fails, print an error and exit
        perror("In mq_open()");
        exit(1);
    }

    /* Get the attributes of the queue (such as max messages, message size, current messages) */
    mq_getattr(msgq_id, &msgq_attr);  // Retrieve and store attributes in msgq_attr
    printf("Queue \"%s\":\n\t- stores at most %ld messages\n\t\
           - large at most %ld bytes each\n\t- currently holds %ld messages\n", 
           MSGQOBJ_NAME, msgq_attr.mq_maxmsg, msgq_attr.mq_msgsize, msgq_attr.mq_curmsgs);

    /* Receive two messages from the queue according to their priority */
    for (int i = 0; i < 2; i++)
    {
        msgsz = mq_receive(msgq_id, msgcontent, MAX_MSG_LEN, &sender);  // Read message content and priority
        if (msgsz == -1) {  // If mq_receive fails, print an error and exit
            perror("In mq_receive()");
            exit(1);
        }
        printf("Received message (%d bytes) from priority %d: %s\n", msgsz, sender, msgcontent);
    }
    
    
    /* Close the message queue */
    mq_close(msgq_id);
    
    /* Unlink (delete) the message queue to clean up */
    mq_unlink(MSGQOBJ_NAME);   
    return 0;
}
