#include <stdio.h>
#include <pthread.h>
#include <unistd.h>
#include <stdlib.h>

#define BUFF_MAX 25
#define MOD(x) ((x) % BUFF_MAX)

struct item {
    // Placeholder structure for the produced or consumed data
    int data;
};

// Shared buffer and synchronization variables
struct item shared_buff[BUFF_MAX];
int free_index = 0;
int full_index = 0;
pthread_mutex_t mtx = PTHREAD_MUTEX_INITIALIZER;

void* producer(void* arg) {
    while (1) {
        struct item new_item;
        new_item.data = rand() % 100;  // Produce some data (example)

        usleep(1000000);  // Simulate production time (100 ms)

        // Wait until there's space in the buffer
        while (MOD(free_index + 1) == full_index) {
            usleep(1000000);  // Wait for consumer to consume
        }

        // Lock the mutex before modifying shared resources
        pthread_mutex_lock(&mtx);

        // Add the item to the buffer
        shared_buff[free_index] = new_item;
        free_index = MOD(free_index + 1);

        // Unlock the mutex after modifying shared resources
        pthread_mutex_unlock(&mtx);
    }
    return NULL;
}

void* consumer(void* arg) {
    while (1) {
        struct item consumed_item;

        // Wait until there's something in the buffer to consume
        while (free_index == full_index) {
            usleep(1000000);  // Wait for producer to produce
        }

        // Lock the mutex before modifying shared resources
        pthread_mutex_lock(&mtx);

        // Consume the item from the buffer
        consumed_item = shared_buff[full_index];
        full_index = MOD(full_index + 1);

        // Unlock the mutex after modifying shared resources
        pthread_mutex_unlock(&mtx);

        // Consume the item (example: print it)
        printf("Consumed item: %d\n", consumed_item.data);

        usleep(1000000);  // Simulate consumption time (1000 ms)
    }
    return NULL;
}

int main() {
    // Initialize threads
    pthread_t producer_thread, consumer_thread;

    // Create producer and consumer threads
    pthread_create(&producer_thread, NULL, producer, NULL);
    pthread_create(&consumer_thread, NULL, consumer, NULL);

    // Wait for both threads to finish (they run indefinitely)
    pthread_join(producer_thread, NULL);
    pthread_join(consumer_thread, NULL);

    // Cleanup
    pthread_mutex_destroy(&mtx);

    return 0;
}

// htop to visualize the processes running...
