package ornekler1C.III;
import java.util.*;
public class Recete {
	private Hasta hasta;
	private Doktor doktor;
	private Date tarih;
	private String receteNo;
	private Ilac[] ilaclar;
	private int ilacSayisi = 0;
	public final static int maxIlac = 10;
	
	public Recete(Hasta hasta, Doktor doktor, Date tarih, String receteNo) {
		this.hasta = hasta;
		this.doktor = doktor;
		this.tarih = tarih;
		this.receteNo = receteNo;
		ilaclar = new Ilac[maxIlac];
	}
	public Hasta getHasta() { return hasta; }
	public Doktor getDoktor() { return doktor; }
	public Date getTarih() { return tarih; }
	public String getReceteNo() { return receteNo; }
	public int getIlacSayisi() { return ilacSayisi; }
	
	/* Eczaclar programlamadan anlamayacaklar iin 
	 * ilk ilac 1. dizi indeksinden balatyoruz. 
	 * */
	public Ilac getIlac( int ilacNo ) {
		if( ilacNo <= ilacSayisi && ilacNo > 0 )
			return ilaclar[ilacNo-1];
		return null;
	}
	public boolean ilacEkle( Ilac ilac ) {
		if( ilacSayisi > maxIlac )
			return false;
		for( int i = 0; i < ilacSayisi; i++ )
			if( getIlac(i+1) == ilac )
				return false;
		ilaclar[ilacSayisi] = ilac; ilacSayisi++;
		return true;
	}
	
}
